// pointers.h

// Declarations for all of our imported glide functions. These are assigned from
// the LoadLibrary("glide2x.dll") call in imports.c

// Copr. 1998 - Justin Frankel/Nullsoft, Inc. (http://www.nullsoft.com)

// Notes: these aren't ALL of the functions exported by glide2x.dll, but they are all most 
// applications should use. Feel free to add more if you need them.

// if we are imports.c, actually create these variables, otherwise delcare them extern
#ifdef IMPORTS_C
#define DECL_TEMP
#else
#define DECL_TEMP extern
#endif

typedef void (*GrErrorCallbackFnc_t)( const char *string, FxBool fatal );

DECL_TEMP void (*_grDrawLine)( const GrVertex *v1, const GrVertex *v2 );
DECL_TEMP void (*_grDrawPlanarPolygon)( int nverts, const int ilist[], const GrVertex vlist[] );
DECL_TEMP void (*_grDrawPlanarPolygonVertexList)( int nverts, const GrVertex vlist[] );
DECL_TEMP void (*_grDrawPoint)( const GrVertex *pt );
DECL_TEMP void (*_grDrawPolygon)( int nverts, const int ilist[], const GrVertex vlist[] );
DECL_TEMP void (*_grDrawPolygonVertexList)( int nverts, const GrVertex vlist[] );
DECL_TEMP void (*_grDrawTriangle)( const GrVertex *a, const GrVertex *b, const GrVertex *c );
DECL_TEMP void (*_grBufferClear)( GrColor_t color, GrAlpha_t alpha, FxU16 depth );
DECL_TEMP int (*_grBufferNumPending)( void );
DECL_TEMP void (*_grBufferSwap)( int swap_interval );
DECL_TEMP void (*_grRenderBuffer)( GrBuffer_t buffer );
DECL_TEMP void (*_grErrorSetCallback)( GrErrorCallbackFnc_t fnc );
DECL_TEMP void (*_grSstIdle)(void);
DECL_TEMP FxU32 (*_grSstVideoLine)( void );
DECL_TEMP FxBool (*_grSstVRetraceOn)( void );
DECL_TEMP FxBool (*_grSstIsBusy)( void );
DECL_TEMP FxBool (*_grSstWinOpen)(FxU32 hWnd,GrScreenResolution_t screen_resolution,GrScreenRefresh_t refresh_rate,
							GrColorFormat_t color_format, GrOriginLocation_t origin_location, int nColBuffers,
							int nAuxBuffers);
DECL_TEMP void (*_grSstWinClose)( void );
DECL_TEMP FxBool (*_grSstControl)( FxU32 code );
DECL_TEMP FxBool (*_grSstQueryHardware)( GrHwConfiguration *hwconfig );
DECL_TEMP FxBool (*_grSstQueryBoards)( GrHwConfiguration *hwconfig );
DECL_TEMP void (*_grSstOrigin)(GrOriginLocation_t  origin);
DECL_TEMP void (*_grSstSelect)( int which_sst );
DECL_TEMP FxU32 (*_grSstScreenHeight)( void );
DECL_TEMP FxU32 (*_grSstScreenWidth)( void );
DECL_TEMP FxU32 (*_grSstStatus)( void );
DECL_TEMP void (*_grSstPerfStats)(GrSstPerfStats_t *pStats);
DECL_TEMP void (*_grSstResetPerfStats)(void);
DECL_TEMP void (*_grResetTriStats)();
DECL_TEMP void (*_grTriStats)(FxU32 *trisProcessed, FxU32 *trisDrawn);
DECL_TEMP void (*_grAlphaBlendFunction)(
                     GrAlphaBlendFnc_t rgb_sf,   GrAlphaBlendFnc_t rgb_df,
                     GrAlphaBlendFnc_t alpha_sf, GrAlphaBlendFnc_t alpha_df);
DECL_TEMP void (*_grAlphaCombine)(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert);
DECL_TEMP void (*_grAlphaControlsITRGBLighting)( FxBool enable );
DECL_TEMP void (*_grAlphaTestFunction)( GrCmpFnc_t function );
DECL_TEMP void (*_grAlphaTestReferenceValue)( GrAlpha_t value );
DECL_TEMP void (*_grChromakeyMode)( GrChromakeyMode_t mode );
DECL_TEMP void (*_grChromakeyValue)( GrColor_t value );
DECL_TEMP void (*_grClipWindow)( FxU32 minx, FxU32 miny, FxU32 maxx, FxU32 maxy );
DECL_TEMP void (*_grColorCombine)(
               GrCombineFunction_t function, GrCombineFactor_t factor,
               GrCombineLocal_t local, GrCombineOther_t other,
               FxBool invert );
DECL_TEMP void (*_grColorMask)( FxBool rgb, FxBool a );
DECL_TEMP void (*_grCullMode)( GrCullMode_t mode );
DECL_TEMP void (*_grConstantColorValue)( GrColor_t value );
DECL_TEMP void (*_grConstantColorValue4)( float a, float r, float g, float b );
DECL_TEMP void (*_grDepthBiasLevel)( FxI16 level );
DECL_TEMP void (*_grDepthBufferFunction)( GrCmpFnc_t function );
DECL_TEMP void (*_grDepthBufferMode)( GrDepthBufferMode_t mode );
DECL_TEMP void (*_grDepthMask)( FxBool mask );
DECL_TEMP void (*_grDisableAllEffects)( void );
DECL_TEMP void (*_grDitherMode)( GrDitherMode_t mode );
DECL_TEMP void (*_grFogColorValue)( GrColor_t fogcolor );
DECL_TEMP void (*_grFogMode)( GrFogMode_t mode );
DECL_TEMP void (*_grFogTable)( const GrFog_t ft[GR_FOG_TABLE_SIZE] );
DECL_TEMP void (*_grGammaCorrectionValue)( float value );
DECL_TEMP void (*_grSplash)(float x, float y, float width, float height, FxU32 frame);
DECL_TEMP FxU32 (*_grTexCalcMemRequired)(GrLOD_t lodmin, GrLOD_t lodmax,GrAspectRatio_t aspect, GrTextureFormat_t fmt);
DECL_TEMP FxU32 (*_grTexTextureMemRequired)( FxU32     evenOdd,     GrTexInfo *info   );
DECL_TEMP FxU32 (*_grTexMinAddress)( GrChipID_t tmu );
DECL_TEMP FxU32 (*_grTexMaxAddress)( GrChipID_t tmu );
DECL_TEMP void (*_grTexNCCTable)( GrChipID_t tmu, GrNCCTable_t table );
DECL_TEMP void (*_grTexSource)( GrChipID_t tmu, FxU32      startAddress, FxU32      evenOdd, GrTexInfo  *info );
DECL_TEMP void (*_grTexClampMode)(GrChipID_t tmu, GrTextureClampMode_t s_clampmode, GrTextureClampMode_t t_clampmode);
DECL_TEMP void (*_grTexCombine)(GrChipID_t tmu,GrCombineFunction_t rgb_function,GrCombineFactor_t rgb_factor, 
					GrCombineFunction_t alpha_function,GrCombineFactor_t alpha_factor,FxBool rgb_invert,
					FxBool alpha_invert);
DECL_TEMP void (*_grTexCombineFunction)(GrChipID_t tmu,GrTextureCombineFnc_t fnc);
DECL_TEMP void (*_grTexDetailControl)(GrChipID_t tmu,int lod_bias,FxU8 detail_scale,float detail_max);
DECL_TEMP void (*_grTexFilterMode)(GrChipID_t tmu,GrTextureFilterMode_t minfilter_mode,GrTextureFilterMode_t magfilter_mode);
DECL_TEMP void (*_grTexLodBiasValue)(GrChipID_t tmu, float bias );
DECL_TEMP void (*_grTexDownloadMipMap)( GrChipID_t tmu,FxU32      startAddress,FxU32      evenOdd,GrTexInfo  *info );
DECL_TEMP void (*_grTexDownloadMipMapLevel)( GrChipID_t        tmu,
                          FxU32             startAddress,
                          GrLOD_t           thisLod,
                          GrLOD_t           largeLod,
                          GrAspectRatio_t   aspectRatio,
                          GrTextureFormat_t format,
                          FxU32             evenOdd,
                          void              *data );
DECL_TEMP void (*_grTexDownloadMipMapLevelPartial)( GrChipID_t        tmu,
                                 FxU32             startAddress,
                                 GrLOD_t           thisLod,
                                 GrLOD_t           largeLod,
                                 GrAspectRatio_t   aspectRatio,
                                 GrTextureFormat_t format,
                                 FxU32             evenOdd,
                                 void              *data,
                                 int               start,
                                 int               end );

DECL_TEMP void (*_ConvertAndDownloadRle)( GrChipID_t        tmu,
                        FxU32             startAddress,
                        GrLOD_t           thisLod,
                        GrLOD_t           largeLod,
                        GrAspectRatio_t   aspectRatio,
                        GrTextureFormat_t format,
                        FxU32             evenOdd,
                        FxU8              *bm_data,
                        long              bm_h,
                        FxU32             u0,
                        FxU32             v0,
                        FxU32             width,
                        FxU32             height,
                        FxU32             dest_width,
                        FxU32             dest_height,
                        FxU16             *tlut);

DECL_TEMP void (*_grCheckForRoom)(FxI32 n);

DECL_TEMP void (*_grTexDownloadTable)( GrChipID_t   tmu,
                    GrTexTable_t type, 
                    void         *data );

DECL_TEMP void (*_grTexDownloadTablePartial)( GrChipID_t   tmu,
                           GrTexTable_t type, 
                           void         *data,
                           int          start,
                           int          end );

DECL_TEMP void (*_grTexMipMapMode)( GrChipID_t     tmu, 
                 GrMipMapMode_t mode,
                 FxBool         lodBlend );

DECL_TEMP void (*_grTexMultibase)( GrChipID_t tmu,
                FxBool     enable );

DECL_TEMP void (*_grTexMultibaseAddress)( GrChipID_t       tmu,
                       GrTexBaseRange_t range,
                       FxU32            startAddress,
                       FxU32            evenOdd,
                       GrTexInfo        *info );

DECL_TEMP GrMipMapId_t (*_guTexAllocateMemory)(
                    GrChipID_t tmu,
                    FxU8 odd_even_mask,
                    int width, int height,
                    GrTextureFormat_t fmt,
                    GrMipMapMode_t mm_mode,
                    GrLOD_t smallest_lod, GrLOD_t largest_lod,
                    GrAspectRatio_t aspect,
                    GrTextureClampMode_t s_clamp_mode,
                    GrTextureClampMode_t t_clamp_mode,
                    GrTextureFilterMode_t minfilter_mode,
                    GrTextureFilterMode_t magfilter_mode,
                    float lod_bias,
                    FxBool trilinear
                    );

DECL_TEMP FxBool (*_guTexChangeAttributes)(
                      GrMipMapId_t mmid,
                      int width, int height,
                      GrTextureFormat_t fmt,
                      GrMipMapMode_t mm_mode,
                      GrLOD_t smallest_lod, GrLOD_t largest_lod,
                      GrAspectRatio_t aspect,
                      GrTextureClampMode_t s_clamp_mode,
                      GrTextureClampMode_t t_clamp_mode,
                      GrTextureFilterMode_t minFilterMode,
                      GrTextureFilterMode_t magFilterMode
                      );

DECL_TEMP void (*_guTexCombineFunction)(
                     GrChipID_t tmu,
                     GrTextureCombineFnc_t fnc
                     );

DECL_TEMP GrMipMapId_t (*_guTexGetCurrentMipMap)( GrChipID_t tmu );

DECL_TEMP GrMipMapInfo * (*_guTexGetMipMapInfo)( GrMipMapId_t mmid );

DECL_TEMP FxU32 (*_guTexMemQueryAvail)( GrChipID_t tmu );

DECL_TEMP void (*_guTexMemReset)( void );

DECL_TEMP void (*_guTexDownloadMipMap)(
                    GrMipMapId_t mmid,
                    const void *src,
                    const GuNccTable *table
                    );

DECL_TEMP void (*_guTexDownloadMipMapLevel)(
                         GrMipMapId_t mmid,
                         GrLOD_t lod,
                         const void **src
                         );
DECL_TEMP void (*_guTexSource)( GrMipMapId_t id );

DECL_TEMP FxBool (*_grLfbLock)( GrLock_t type, GrBuffer_t buffer, GrLfbWriteMode_t writeMode,
           GrOriginLocation_t origin, FxBool pixelPipeline, 
           GrLfbInfo_t *info );
DECL_TEMP FxBool (*_grLfbUnlock)( GrLock_t type, GrBuffer_t buffer );
DECL_TEMP void (*_grLfbConstantAlpha)( GrAlpha_t alpha );
DECL_TEMP void (*_grLfbConstantDepth)( FxU16 depth );
DECL_TEMP void (*_grLfbWriteColorSwizzle)(FxBool swizzleBytes, FxBool swapWords);
DECL_TEMP void (*_grLfbWriteColorFormat)(GrColorFormat_t colorFormat);
DECL_TEMP FxBool (*_grLfbWriteRegion)( GrBuffer_t dst_buffer, 
                  FxU32 dst_x, FxU32 dst_y, 
                  GrLfbSrcFmt_t src_format, 
                  FxU32 src_width, FxU32 src_height, 
                  FxI32 src_stride, void *src_data );
DECL_TEMP FxBool (*_grLfbReadRegion)( GrBuffer_t src_buffer,
                 FxU32 src_x, FxU32 src_y,
                 FxU32 src_width, FxU32 src_height,
                 FxU32 dst_stride, void *dst_data );
DECL_TEMP void (*_grAADrawLine)(const GrVertex *v1, const GrVertex *v2);
DECL_TEMP void (*_grAADrawPoint)(const GrVertex *pt );
DECL_TEMP void (*_grAADrawPolygon)(const int nverts, const int ilist[], const GrVertex vlist[]);
DECL_TEMP void (*_grAADrawPolygonVertexList)(const int nverts, const GrVertex vlist[]);
DECL_TEMP void (*_grAADrawTriangle)(
                 const GrVertex *a, const GrVertex *b, const GrVertex *c,
                 FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
                 );
DECL_TEMP void (*_grGlideInit)( void );
DECL_TEMP void (*_grGlideShutdown)( void );
DECL_TEMP void (*_grGlideGetVersion)( char version[80] );
DECL_TEMP void (*_grGlideGetState)( GrState *state );
DECL_TEMP void (*_grGlideSetState)( const GrState *state );
DECL_TEMP void (*_grGlideShamelessPlug)(const FxBool on);
DECL_TEMP void (*_grHints)(GrHint_t hintType, FxU32 hintMask);
DECL_TEMP void (*_guAADrawTriangleWithClip)( const GrVertex *a, const GrVertex *b, const GrVertex *c);
DECL_TEMP void (*_guDrawTriangleWithClip)(const GrVertex *a,const GrVertex *b,const GrVertex *c);
DECL_TEMP void (*_guDrawPolygonVertexListWithClip)( int nverts, const GrVertex vlist[] );
DECL_TEMP void (*_guAlphaSource)( GrAlphaSource_t mode );
DECL_TEMP void (*_guColorCombineFunction)( GrColorCombineFnc_t fnc );
DECL_TEMP int (*_guEncodeRLE16)( void *dst, void *src, FxU32 width, FxU32 height );
DECL_TEMP FxU16 *(*_guTexCreateColorMipMap)( void );
DECL_TEMP void (*_guMovieStart)( void );
DECL_TEMP void (*_guMovieStop)( void );
DECL_TEMP void (*_guMovieSetName)( const char *name );
DECL_TEMP float (*_guFogTableIndexToW)( int i );
DECL_TEMP void (*_guFogGenerateExp)( GrFog_t fogtable[GR_FOG_TABLE_SIZE], float density );
DECL_TEMP void (*_guFogGenerateExp2)( GrFog_t fogtable[GR_FOG_TABLE_SIZE], float density );
DECL_TEMP void (*_guFogGenerateLinear)(GrFog_t fogtable[GR_FOG_TABLE_SIZE],float nearZ, float farZ );
DECL_TEMP FxU32 (*_guEndianSwapWords)( FxU32 value );
DECL_TEMP FxU16 (*_guEndianSwapBytes)( FxU16 value );
DECL_TEMP FxBool (*_gu3dfGetInfo)( const char *filename, Gu3dfInfo *info );
DECL_TEMP FxBool (*_gu3dfLoad)( const char *filename, Gu3dfInfo *data );

#undef DECL_TEMP
